/* - IRDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.IRPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextArea;

public class IRDetachListener implements DetachListener {

    private JFrame appFrame;
    private JPanel codePanel;
    private JPanel learnPanel;
    private JPanel rawDataPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    private JTextField codeTxt;
    private JTextField bitLengthTxt;
    private JTextField repeatCountTxt;

    private JTextField learnIRCodeTxt;
    private JTextField learnBitLengthTxt;
    private JTextField learnEncodingTxt;
    private JTextField learnLengthTxt;
    private JTextField learnGapTxt;
    private JTextField learnTrailTxt;
    private JTextField learnZeroTxt;
    private JTextField learnOneTxt;
    private JTextField learnHeaderTxt;
    private JTextField learnRepeatTxt;
    private JTextField learnToggleMaskTxt;
    private JButton retransmitBtn;

    private JTextArea rawDataArea;

    public IRDetachListener(JFrame appFrame, JPanel codePanel, JPanel learnPanel, JPanel rawDataPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField codeTxt, JTextField bitLengthTxt, JTextField repeatCountTxt,
            JTextField learnIRCodeTxt, JTextField learnBitLengthTxt, JTextField learnEncodingTxt, JTextField learnLengthTxt,
            JTextField learnGapTxt, JTextField learnTrailTxt, JTextField learnZeroTxt, JTextField learnOneTxt, JTextField learnHeaderTxt,
            JTextField learnRepeatTxt, JTextField learnToggleMaskTxt, JButton retransmitBtn, JTextArea rawDataArea){
        this.appFrame = appFrame;
        this.codePanel = codePanel;
        this.learnPanel = learnPanel;
        this.rawDataPanel = rawDataPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;

        this.codeTxt = codeTxt;
        this.bitLengthTxt = bitLengthTxt;
        this.repeatCountTxt = repeatCountTxt;

        this.learnIRCodeTxt = learnIRCodeTxt;
        this.learnBitLengthTxt = learnBitLengthTxt;
        this.learnEncodingTxt = learnEncodingTxt;
        this.learnLengthTxt = learnLengthTxt;
        this.learnGapTxt = learnGapTxt;
        this.learnTrailTxt = learnTrailTxt;
        this.learnZeroTxt = learnZeroTxt;
        this.learnOneTxt = learnOneTxt;
        this.learnHeaderTxt = learnHeaderTxt;
        this.learnRepeatTxt = learnRepeatTxt;
        this.learnToggleMaskTxt = learnToggleMaskTxt;
        this.retransmitBtn = retransmitBtn;

        this.rawDataArea = rawDataArea;
     }

    public void detached(DetachEvent de) {
        try {

            appFrame.setSize(357, 260);

            IRPhidget detached = (IRPhidget) de.getSource();
            codePanel.setEnabled(false);
            codePanel.setVisible(false);

            learnPanel.setEnabled(false);
            learnPanel.setVisible(false);

            rawDataPanel.setEnabled(false);
            rawDataPanel.setVisible(false);

            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");

            codeTxt.setText("");
            bitLengthTxt.setText("");
            repeatCountTxt.setText("");

            learnIRCodeTxt.setText("");
            learnBitLengthTxt.setText("");
            learnEncodingTxt.setText("");
            learnLengthTxt.setText("");
            learnGapTxt.setText("");
            learnTrailTxt.setText("");
            learnZeroTxt.setText("");
            learnOneTxt.setText("");
            learnHeaderTxt.setText("");
            learnRepeatTxt.setText("");
            learnToggleMaskTxt.setText("");
            retransmitBtn.setEnabled(false);

            rawDataArea.setText(null);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }


}
